# Domain.java Class Diagram

```mermaid
classDiagram
    class Domain {
        <<abstract>>
    }
    
    class MigrationTask {
        +String root
        +String notes
        +List~Classification~ classifications
        +MigrationTask(String root, String notes)
        +MigrationTask(String root, String notes, List~Classification~ classifications)
        +SoftwareProject softwareProject()
    }
    
    class Classification {
        +String name
        +String description
    }
    
    class MigrationPossibility {
        +String filePath
    }
    
    class MigrationPoint {
        +String filePath
        +String description
        +String classificationName
    }
    
    class MigrationPoints {
        +List~MigrationPoint~ migrationPoints
        +String overview
    }
    
    class MigrationReport {
        +MigrationPoint migrationPoint
        +boolean success
        +String notes
        +String branch
        +MigrationReport withBranch(String branch)
    }
    
    class MigrationsReport {
        +List~MigrationReport~ migration
    }
    
    class SoftwareProject {
        <<external>>
    }
    
    Domain --> MigrationTask : contains
    Domain --> MigrationPossibility : contains
    Domain --> MigrationPoint : contains
    Domain --> MigrationPoints : contains
    Domain --> MigrationReport : contains
    Domain --> MigrationsReport : contains
    
    MigrationTask --> Classification : has many
    MigrationTask --> SoftwareProject : creates
    MigrationPoints --> MigrationPoint : contains many
    MigrationReport --> MigrationPoint : references
    MigrationsReport --> MigrationReport : contains many
```

This diagram shows the domain model structure for the Java Code Modernizer Agent, including all record types and their relationships.